from flask import Flask, request, jsonify
import cv2
import numpy as np
import mediapipe as mp
import base64

app = Flask(__name__)
mp_face_detection = mp.solutions.face_detection
mp_drawing = mp.solutions.drawing_utils

def detect_faces(image):
    with mp_face_detection.FaceDetection(model_selection=1, min_detection_confidence=0.5) as face_detection:
        results = face_detection.process(cv2.cvtColor(image, cv2.COLOR_BGR2RGB))
        if not results.detections:
            return []
        return [detection for detection in results.detections]

@app.route('/detect', methods=['POST'])
def detect():
    data = request.json
    image_data = base64.b64decode(data['image'])
    nparr = np.frombuffer(image_data, np.uint8)
    img = cv2.imdecode(nparr, cv2.IMREAD_COLOR)
    
    faces = detect_faces(img)
    if faces:
        return jsonify({"success": True, "message": "Face detected", "num_faces": len(faces)})
    else:
        return jsonify({"success": False, "message": "No face detected"})

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5000)
