<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Profile</title>
    
    <!-- Add the html2canvas library -->
    <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
    <!-- Add the html2pdf library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
    
    <style>
        .a4-paper {
            width: 297mm;
            height: 210mm;
            margin: 0px 10px;
            background-color: #ffffff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-content: flex-start;
            padding: 10px; /* Add padding for spacing */
            box-sizing: border-box; /* Ensure padding is included in width */
        }

        .idcard {
            width: 56mm;
            height: 210mm;
            margin-bottom: 20px; /* Bottom margin for spacing */
            background: url('idcard.png') no-repeat center center;
            background-size: cover;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
        }

        .idcard .content {
            padding: 10px;
            font-family: Arial, sans-serif;
            color: #ffffff;
            text-align: center;
        }

        .pagination {
            text-align: center;
            margin-top: 20px;
        }

        .pagination a {
            display: inline-block;
            padding: 10px 20px;
            margin: 5px;
            border: 1px solid #3498db;
            background-color: #333;
            color: #fff;
            text-decoration: none;
            border-radius: 5px;
        }

        .pagination a:hover {
            background-color: #000;
        }
    </style>
</head>
<body>

<div class="a4-paper" id="content-to-download">
    <?php
    session_start();
    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    // Establish database connection
    $servername = "localhost";
    $username = "safegua6_adds";
    $password = "@mashaAllah1";
    $database = "safegua6_fursa";

    // Create connection
    $conn = new mysqli($servername, $username, $password, $database);

    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Pagination logic
    $results_per_page = 5; // Number of records per page
    if (isset($_GET["page"])) {
        $page = $_GET["page"];
    } else {
        $page = 1;
    }
    $start_from = ($page - 1) * $results_per_page;

    // Retrieve staff members with pagination
    $sql = "SELECT employees.*, employees.id AS empid, employees.photo, employees.qr_code, position.description 
            FROM employees 
            LEFT JOIN position ON position.id=employees.position_id
            LIMIT $start_from, $results_per_page";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        // Loop through each staff member
        while ($user = $result->fetch_assoc()) {
            $staff_id = $user["empid"];
            $contact_info = $user["contact_info"];
            $position_id = $user["position_id"];
            $address = $user["address"];
            $photo = $user["photo"];
            $qr_code = $user["qr_code"];
            $position_description = $user["description"];

            // Display staff ID card
            echo "<div class='idcard'>";
            echo "<div class='content'>";
               // Display user's address and QR code within a flex container
            echo '<div style="display: flex; justify-content: space-between; margin-top: 1px;">';
        echo "<img style='width: 25%; ' src='lg.png' alt='QR Code'>";
        echo '<div style="width: 75%;">';
        echo '<strong style="text-align: left; font-size: 12px; color: black;">FURSA FOODS LIMITED</strong>';
        echo '<p style="text-align: left; margin: 0;
            padding: 0; font-size: 10px; color: black;">
No. 315 Yahaya Gusau Road, Kofar Bompai, Kano Nigeria</p>';

        echo '</div>';
        echo '</div>';
  
            echo "<br>";











            // Display user's photo if available
            if (!empty($photo)) {
                $photoPath = "../fursa/images/" . htmlspecialchars($photo);
                echo "<img style='width: 100px; height: 100px; border-radius: 50%; border: 2px solid #E1C16E;' src='$photoPath' alt='User Photo'>";
            }

            // Display user's details
            echo "<br>";
            echo "<strong style='font-size:15px; background-color: black;' >" . htmlspecialchars($user['firstname']) . " " . htmlspecialchars($user['lastname']) . "</strong><br>";

            echo "<strong style='padding: 100px; width: 100%; color: red; font-size: 12px; white-space: nowrap;'>" . htmlspecialchars($position_description) . "</strong><br>";
            
              echo '<hr>';

            echo "<strong style='font-size:13px; color: black'>" . htmlspecialchars($user['contact_info']) . "</strong><br>";

            // Display user's address and QR code within a flex container
            echo '<div style="display: flex; justify-content: space-between; margin-top: 10px;">';
            echo '<p style="width: 65%; text-align: left; font-size: 13px; color: black;">' . htmlspecialchars($address) . '</p>';
            
            // Display user's QR code if available
            if (!empty($qr_code)) {
                $qrCodePath = "../fursa/admin/" . htmlspecialchars($qr_code);
                echo "<img style='width: 35%; height: auto;' src='$qrCodePath' alt='QR Code'>";
            }
            echo '</div>';
            
            echo "<br><br><br><br>";
            if (!empty($qr_code)) {
                $qrCodePath = "../fursa/admin/" . htmlspecialchars($qr_code);
                echo "<img style='width: 80%; height: auto;' src='$qrCodePath' alt='QR Code'>";
            }
            
              echo '</br>';echo '</br>';echo '</br>';
             echo "<strong style='font-size:15px; background-color: black;' >For assistance, Please Contact</strong><br>";
            
                  echo '<div style="display: flex; justify-content: space-between; margin-top: 1px;">';
        echo "<img style='width: 25%; ' src='lg.png' alt='QR Code'>";
        echo '<div style="width: 75%;">';
        echo '<strong style="text-align: left; font-size: 12px; color: black;">FURSA FOODS LIMITED</strong>';
        echo '<p style="text-align: left; margin: 0;
            padding: 0; font-size: 10px; color: black;">
No. 315 Yahaya Gusau Road, Kofar Bompai, Kano Nigeria</p>';

        echo '</div>';
        echo '</div>';
            
            echo "</div>"; // Close .content
            echo "</div>"; // Close .idcard
        }
    } else {
        echo "No staff members found.";
    }

    // Pagination controls
    $sql = "SELECT COUNT(*) AS total FROM employees";
    $result = $conn->query($sql);
    $row = $result->fetch_assoc();
    $total_pages = ceil($row["total"] / $results_per_page);

    echo '<div class="pagination">';
    if ($page > 1) {
        echo '<a href="idcard.php?page=' . ($page - 1) . '">Previous</a>';
    }
    for ($i = 1; $i <= $total_pages; $i++) {
        if ($i == $page) {
            echo '<a style="background-color: #3498db;">' . $i . '</a>';
        } else {
            echo '<a href="idcard.php?page=' . $i . '">' . $i . '</a>';
        }
    }
    if ($page < $total_pages) {
        echo '<a href="idcard.php?page=' . ($page + 1) . '">Next</a>';
    }
    echo '</div>';

    // Close connection
    $conn->close();
    ?>
</div>

<div class="button-container">
    <button onclick="downloadPageAsImage()">Download Page as Image</button>
    <button onclick="downloadPageAsPDF()">Download Page as PDF</button>
</div>

<script>
    function downloadPageAsImage() {
        var element = document.getElementById('content-to-download');

        html2canvas(element, {
            scale: 4,  // Increase the scale to improve image resolution
            useCORS: true  // Enable cross-origin images
        }).then(function (canvas) {
            var link = document.createElement('a');
            link.href = canvas.toDataURL('image/png');
            link.download = 'page.png';
            link.click();
        });
    }

    function downloadPageAsPDF() {
        var element = document.getElementById('content-to-download');

        var options = {
            filename: 'page.pdf',
            image: { type: 'jpeg', quality: 0.98 },
            html2canvas: { scale: 3, useCORS: true },  // Increase the scale for better quality and enable cross-origin images
            jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
        };

        html2pdf().from(element).set(options).save();
    }
</script>

<style>
    .button-container {
        text-align: center;
        margin-top: 20px;
    }

    .button-container button {
        display: inline-block;
        padding: 10px 20px;
        font-size: 16px;
        text-align: center;
        text-decoration: none;
        cursor: pointer;
        border: 1px solid #3498db;
        color: #ffffff;
        background-color: #333;
        border-radius: 5px;
        margin: 5px;
    }

    .button-container button:hover {
        background-color: #000;
    }
</style>

</body>
</html>
